import string

import allure
from faker import Faker


from pages.final_volgait_page import FinalVolgaITPage
from tests.base_test import BaseTest

@allure.epic("Финал Volga-IT")
@allure.feature("Заполнение регистрационной формы")
class TestFinalFormPage(BaseTest):
    def setup_method(self):
        self.form_page = FinalVolgaITPage(self.driver)
        self.form_page.open()

    @allure.title("Тест заполнения всех полей формы, успешно")
    def test_full_registration_form_success(self):
        try:
            with allure.step("Заполнить имя"):
                first_name = Faker().first_name()
                self.form_page.enter_firstname(first_name)
                assert first_name == self.form_page.check_firstname()

            with allure.step("Заполнить фамилию"):
                last_name = Faker().last_name()
                self.form_page.enter_lastname(last_name)
                assert last_name == self.form_page.check_lastname()

            with allure.step("Заполнить семейное положение"):
                status = "Single"
                self.form_page.set_marital_status(status)
                assert self.form_page.check_married_status(status)

            with allure.step("Заполнить хобби 'Чтение'"):
                hobby = "Reading"
                self.form_page.set_hobby(hobby)
                assert self.form_page.check_hobby(hobby)

            with allure.step("Заполнить хобби 'Танцы'"):
                hobby = "Dance"
                self.form_page.set_hobby(hobby)
                assert self.form_page.check_hobby(hobby)

            with allure.step("Выбрать ВТОРУЮ страну в списке"):
                index = 1
                self.form_page.select_country(index)
                assert self.form_page.check_country(index)

            with allure.step("Заполнить дату рождения"):
                with allure.step("Заполнить ДЕНЬ рождения"):
                    day = "1"
                    self.form_page.select_day_of_birth("1")
                    assert self.form_page.check_day_of_birth(day)

                with allure.step("Заполнить МЕСЯЦ рождения"):
                    month = "1"
                    self.form_page.select_month_of_birth("1")
                    assert self.form_page.check_month_of_birth(month)

                with allure.step("Заполнить ГОД рождения"):
                    year = "2014"
                    self.form_page.select_year_of_birth("2014")
                    assert self.form_page.check_year_of_birth(year)

            with allure.step("Заполнить номер телефона"):
                phone = Faker().phone_number()
                self.form_page.enter_phone(phone)
                assert phone == self.form_page.check_phone()

            with allure.step("Заполнить никнейм"):
                username = "ABOBUS"
                self.form_page.enter_username(username)
                assert username == self.form_page.check_username()

            with allure.step("Заполнить электронную почту"):
                email = Faker().email()
                self.form_page.enter_email(email)
                assert email == self.form_page.check_email()

            with allure.step("Загрузить картинку"):
                self.form_page.upload_file("Закат.jpg")

            with allure.step("Заполнить поле обо мне"):
                self.form_page.enter_answers_to_about_yourself()

            password = Faker().password(length=10)
            with allure.step("Заполнить пароль"):
                self.form_page.enter_password(password)
                assert password == self.form_page.check_password()

            with allure.step("Подтвердить пароль"):
                self.form_page.enter_confirm_password(password)
                assert password == self.form_page.check_confirm_password()

            with allure.step("Нажать кнопку Submit"):
                self.form_page.click_submit()

            with allure.step("Проверить заполненность обязательных полей"):
                count = self.form_page.check_required_fields()
                assert count == 0, f"Кол-во незаполненных полей: {count}"

        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.title("Тест заполнения обязательных полей формы, успешно")
    def test_mandatory_registration_form(self):
        try:
            with allure.step("Заполнить имя"):
                first_name = Faker().first_name()
                self.form_page.enter_firstname(first_name)
                assert first_name == self.form_page.check_firstname()

            with allure.step("Заполнить фамилию"):
                last_name = Faker().last_name()
                self.form_page.enter_lastname(last_name)
                assert last_name == self.form_page.check_lastname()

            with allure.step("Заполнить хобби 'Крикет'"):
                hobby = "Cricket"
                self.form_page.set_hobby(hobby)
                assert self.form_page.check_hobby(hobby)

            with allure.step("Заполнить номер телефона"):
                phone = Faker().phone_number()
                self.form_page.enter_phone(phone)
                assert phone == self.form_page.check_phone()

            with allure.step("Заполнить никнейм"):
                username = "ABOBUS"
                self.form_page.enter_username(username)
                assert username == self.form_page.check_username()

            with allure.step("Заполнить электронную почту"):
                email = Faker().email()
                self.form_page.enter_email(email)
                assert email == self.form_page.check_email()

            password = Faker().password(length=4)
            with allure.step("Заполнить пароль"):
                self.form_page.enter_password(password)
                assert password == self.form_page.check_password()

            with allure.step("Подтвердить пароль"):
                self.form_page.enter_confirm_password(password)
                assert password == self.form_page.check_confirm_password()

            with allure.step("Нажать кнопку Submit"):
                self.form_page.click_submit()

            with allure.step("Проверить заполненность обязательных полей"):
                count = self.form_page.check_required_fields()
                assert count == 0, f"Кол-во незаполненных полей: {count}"

        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.title("Тест пустой формы регистрации")
    def test_void_registration_form_unsucces(self):
        try:
            with allure.step("Нажать кнопку Submit"):
                self.form_page.click_submit()

            with allure.step("Проверить заполненность обязательных полей"):
                count = self.form_page.check_required_fields()
                assert count == 7, f"Заполнены все обязательные поля, регистрация успешно"

        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.title("Тест частично заполненной формы регистрации, неуспешно")
    def test_partial_registration_form_unsucces(self):
        try:
            with allure.step("Заполнить имя"):
                self.form_page.enter_firstname(Faker().first_name())

            with allure.step("Заполнить фамилию"):
                self.form_page.enter_lastname(Faker().last_name())

            with allure.step("Нажать кнопку Submit"):
                self.form_page.click_submit()

            with allure.step("Проверить заполненность обязательных полей"):
                count = self.form_page.check_required_fields()
                assert count == 6, f"Заполнены все обязательные поля, регистрация успешно"

        except Exception as e:
            self.allure_screenshot()
            raise e